<?php

if ( post_password_required() )
	return;
?>

<div id="comments" class="comments-area">
	<?php
		$commenter     = wp_get_current_commenter();
		$user          = wp_get_current_user();
		$user_identity = $user->exists() ? $user->display_name : '';
		$req           = get_option( 'require_name_email' );
		$aria_req      = ( $req ? " aria-required='true'" : '' );
	?>

	<ul>
		<p style="text-align:center;"> لطفا قبل از ارسال دیدگاه خود، موارد زیر را به دقت مطالعه کنید :</p>
		<p style="text-align:center;">=-=-=-=-=-=-==-=-=</p>
		<li>دیدگاهی که به غیر از زبان فارسی یا غیرمرتبط با مطلب باشد منتشر نخواهد شد.</li>
		<li>دیدگاه ارسال شده توسط شما، پس از تایید توسط مدیران سایت منتشر خواهد شد.</li>
		<li>درخواست های خود برای بازی ها و برنامه ها را فقط از طریق صفحه <strong><a href="/app-request/" target="_blank">«درخواست بازی و برنامه»</a></strong> ارسال کنید.</li>
	</ul>

	<?php if ( is_user_logged_in() ) : ?>
		<p class="thankful"><?php echo sprintf('<strong>%1$s</strong> عزیز،  از اینکه با نظرات مفید خود باعث دلگرمی ما می شوید متشکریم.', $user_identity ); ?></p>
	<?php endif; ?>

	<?php
		comment_form( array(
			'must_log_in' => '<p class="must-log-in">' .  sprintf('شما باید <a href="%s">وارد شوید</a> تا نظر بنویسید.' , wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</p>',
			'logged_in_as' => '',
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'title_reply' =>  '',
			'title_reply_to' =>  'پاسخ به %s',
			'cancel_reply_link' => 'انصراف',
			'label_submit' => 'ارسال دیدگاه' 
		));
	?>

	<?php if ( have_comments() ) : ?>
	<ol class="comment-list">
		<?php
			wp_list_comments( array(
				'callback'       => 'custom_comments',
				'style'       => 'ol'
			) );
		?>
	</ol>
	<?php endif; ?>

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
	<div class="navigation">
		<div class="previous_comments"><?php previous_comments_link('نظرات قدیمی') ?></div>
		<div class="next_comments"><?php next_comments_link('نظرات جدید'); ?></div>
	</div>
	<?php endif; ?>

	<?php if ( ! comments_open() && get_comments_number() ) : ?>
	<p class="no-comments">نظرات بسته شده است.</p>
	<?php endif; ?>

</div>