<?php?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">

<head>

<title><?php wp_title('&raquo;','true','right'); ?></title>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php endif; ?>
<?php wp_head(); ?>

<meta name="google-site-verification" content="giB7KI5r1O5A3ItVGvgMIlfyRd0tWl5R9Gjl4RFwqG8" />
<meta name="majestic-site-verification" content="MJ12_6057f826-5a00-4416-a9fa-7fd073440f43">

<link rel="shortcut icon" href="<?php bloginfo('template_url');?>/images/favicon.ico">
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/style.css" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/icon.css"/>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/slick.css"/>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/uikit.css"/>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/slick-theme.css"/>

<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/jquery-1.12.4.min.js"></script>

<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/slick.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/uikit.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/sticky.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/modal.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/nicescroll.min.js"></script>

<script>
$(window).resize(function(){
	if ($(window).width() <= 561){	
		$(".rside section").attr("data-uk-sticky","{boundary: '.lside'}");
	}
});
</script>

</head>

<body <?php body_class(); ?>>

	<section class="main">
		<header>
			<a class="logo" href="/" title="AppRoid" alt="مرجع دانلود بازی و برنامه اندروید"><img src="<?php bloginfo('template_url');?>/images/header-logo.png"></a>
			<ul class="headmenu">
				<li><a href="/ads">تبلیغات</a></li>
				<li><a href="/contact-us/">تماس با ما</a></li>
				<li><a href="/about-us/">درباره ما</a></li>
				<li><a href="/app-request/">درخواست برنامه</a></li>
			</ul>
		</header>

		<nav>
			<div class="navmenu">
				<?php wp_nav_menu( array( 'theme_location' => 'nvamenu' ) ); ?>
			</div>
			<form class="search" action="<?php echo get_site_url(); ?>" name="searchform" method="get">
				<input type="text" placeholder="جستجو..." value="" name="s">
				<button type="submit">
					<i class="icon icon-search"></i>
				</button>
			</form>
		</nav>