<?php
/*
Plugin Name: Latest News Widget
Plugin URI: http://approid.ir
Description: Display Latest Post From News Category
Author: M3HDI
Version: 1
*/

class LatestNews extends WP_Widget {
	function LatestNews() {
		$widget_ops = array('classname' => 'LatestNews', 'description' => 'نمایش آخرین مطالب دسته اخبار' );
		$this->WP_Widget('LatestNews', 'آخرین اخبار', $widget_ops);
	}

	function form($instance) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => 'آخرین اخبار' ) );
		$title = $instance['title'];
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>">Title: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo attribute_escape($title); ?>" /></label></p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		return $instance;
	}

	function widget($args, $instance) {
		extract($args, EXTR_SKIP);

		echo $before_widget;
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);

		if (!empty($title))
		echo $before_title . $title . $after_title;;


		// WIDGET CODE GOES HERE
		query_posts('showposts=5&cat=11');
		if (have_posts()) : 
		echo "<ul>";
		while (have_posts()) : the_post(); 
		echo "<li>","<a href=".get_the_permalink().">".get_the_title()."</a>","</li>";
		endwhile;
		echo "</ul>";
		endif; 
		wp_reset_query();

		echo $after_widget;
	}
}

add_action( 'widgets_init', create_function('', 'return register_widget("LatestNews");') );?>