<?php
/*
Plugin Name: Recent Comments Widget
Plugin URI: http://approid.ir
Description: Display Users Recent Comments
Author: M3HDI
Version: 1
*/

class RecentComments extends WP_Widget {
	function RecentComments() {
		$widget_ops = array('classname' => 'RecentComments', 'description' => 'نمایش آخرین نظرات کابران' );
		$this->WP_Widget('RecentComments', 'آخرین نظرات', $widget_ops);
	}

	function form($instance) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => 'آخرین نظرات' ) );
		$title = $instance['title'];
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>">Title: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo attribute_escape($title); ?>" /></label></p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		return $instance;
	}

	function widget($args, $instance) {
		extract($args, EXTR_SKIP);

		echo $before_widget;
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);

		if (!empty($title))
		echo $before_title . $title . $after_title;;


		// WIDGET CODE GOES HERE
		echo recent_comments('5', '36');
		echo $after_widget;
	}
}

add_action( 'widgets_init', create_function('', 'return register_widget("RecentComments");') );?>