<?php
add_action('add_meta_boxes','wd_meta_box_add');
function wd_meta_box_add() { add_meta_box('wd-meta-box','اطلاعات دانلود','wd_meta_box_cb','post','normal','high'); }

add_action( 'admin_enqueue_scripts', 'wd_meta_box_init' );
function wd_meta_box_init() { wp_enqueue_style('wd_meta_box_css', get_template_directory_uri().'/meta/style.css'); }

function wd_meta_box_cb() {
	global $post;
	$values = get_post_custom($post->ID);
	$wd_version = isset($values['wd_version']) ? esc_attr($values['wd_version'][0]) : '';
	$wd_dl = isset($values['wd_dl']) ? esc_attr($values['wd_dl'][0]) : '';
	$wd_dl_size = isset($values['wd_dl_size']) ? esc_attr($values['wd_dl_size'][0]) : '';
	$wd_star = isset($values['wd_star']) ? esc_attr($values['wd_star'][0]) : '';
	$wd_data = isset($values['wd_data']) ? esc_attr($values['wd_data'][0]) : '';
	$wd_data_size = isset($values['wd_data_size']) ? esc_attr($values['wd_data_size'][0]) : '';
	wp_nonce_field('wd_meta_box_nonce','meta_box_nonce');
?>
	<div class="wd-meta-box">
		<p><label>نسخه اندروید مورد نیاز:</label> <input type="text" name="wd_version" value="<?php echo $wd_version; ?>"> <span><b>مثال: </b><span class="red">2.3</span> کلمه ی "و بالاتر" به صورت خودکار اضافه می شود</span></p>
		<p><label>حجم فایل:</label> <input type="text" name="wd_dl_size" value="<?php echo $wd_dl_size; ?>"> <span><b>مثال: </b><span class="red">7</span> کلمه ی "و مگابایت" به صورت خودکار اضافه می شود</span></p>
		<p><label>حجم فایل دیتا:</label> <input type="text" name="wd_data_size" value="<?php echo $wd_data_size; ?>"> <span><b>مثال: </b><span class="red">726</span> کلمه ی "و مگابایت" به صورت خودکار اضافه می شود</span></p>
		<p><label>امتیاز:</label> <input type="text" name="wd_star" value="<?php echo $wd_star; ?>"> <span><b>مثال: </b><span class="red">4.1</span>/5</span></p>
		<p><label>لینک دانلود:</label> <input type="text" name="wd_dl" class="wd_dl" value="<?php echo $wd_dl; ?>"></p>
		<p><label>لینک فایل دیتا:</label> <input type="text" name="wd_data" class="wd_dl" value="<?php echo $wd_data; ?>"></p>
	</div>
<?php }
add_action('save_post','wd_meta_box_save');
function wd_meta_box_save($post_id) {
	global $post;
	if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
	if(!isset($_POST['meta_box_nonce']) || !wp_verify_nonce($_POST['meta_box_nonce'],'wd_meta_box_nonce')) return;
	if(!current_user_can('edit_post', $post->ID)) return;
	
	if(isset($_POST['wd_version'])) { update_post_meta($post_id,'wd_version',esc_attr($_POST['wd_version'])); }
	if(isset($_POST['wd_dl_size'])) { update_post_meta($post_id,'wd_dl_size',esc_attr($_POST['wd_dl_size'])); }
	if(isset($_POST['wd_star'])) { update_post_meta($post_id,'wd_star',esc_attr($_POST['wd_star'])); }
	if(isset($_POST['wd_data_size'])) { update_post_meta($post_id,'wd_data_size',esc_attr($_POST['wd_data_size'])); }
	if(isset($_POST['wd_dl'])) { update_post_meta($post_id,'wd_dl',esc_attr($_POST['wd_dl'])); }
	if(isset($_POST['wd_data'])) { update_post_meta($post_id,'wd_data',esc_attr($_POST['wd_data'])); }
}
?>