<?php
/**
 * Conditionally displays a message if the $post_id is 2
 */
function yourprefix_before_row_if_2( $field_args, $field ) {
	if ( 2 == $field->object_id ) {
		echo '<p>Testing <b>"before_row"</b> parameter (on $post_id 2)</p>';
	} else {
		echo '<p>Testing <b>"before_row"</b> parameter (<b>NOT</b> on $post_id 2)</p>';
	}
}

function specific_category_metabox( $cmb ) {
	// Don't show this metabox if not in this category.
	if ( has_category( '46', $cmb->object_id ) || has_category( '2', $cmb->object_id ) ) {
		return true;
	}
	return false;
}

function specific_category_field_movies( $field ) {
	// Don't show this field if not in this category.
	if ( !has_category( '46', $field->object_id ) ) {
		return false;
	}
	return true;
}

function specific_category_field_series( $field ) {
	// Don't show this field if not in this category.
	if ( !has_category( '2', $field->object_id ) ) {
		return false;
	}
	return true;
}

add_action( 'cmb2_admin_init', 'details_metabox' );
function details_metabox() {
	$prefix = 'dmb_';

	$cmb = new_cmb2_box( array(
		'id'			=>	$prefix . 'title',
		'title'			=>	esc_html__( 'جزئیات', 'cmb2' ),
		'object_types'	=>	array( 'post', ),
		'show_on_cb'	=>	'specific_category_metabox', // function should return a bool value
	) );

	$cmb->add_field( array(
		'name'		=>	esc_html__( 'نام انگلیسی', 'cmb2' ),
		'id'		=>	$prefix . 'english_name',
		'type'		=>	'text',
	) );
	$cmb->add_field( array(
		'name'			=>	esc_html__( 'امتیاز', 'cmb2' ),
		'id'			=>	$prefix . 'imdb_score',
		'type'			=>	'text',
		'attributes'	=>	array(
			'type'		=>	'number',
			'step'		=>	'any',
		),
	) );
	$cmb->add_field( array(
		'name'		=>	esc_html__( 'فعالسازی تبلیغات', 'cmb2' ),
		'id'		=>	$prefix . 'advertising_status',
		'type'		=>	'checkbox',
	) );
	$cmb->add_field( array(
		'name'		=>	esc_html__( 'لینک تبلیغات', 'cmb2' ),
		'id'		=>	$prefix . 'advertising_link',
		'type'		=>	'text_url',
	) );
	$cmb->add_field( array(
		'name'			=>	esc_html__( 'عکس های اضافی', 'cmb2' ),
		'id'			=>	$prefix . 'other_images',
		'type'			=>	'file',
	) );
    $cmb->add_field( array(
        'name'			=>	__( 'مطالب کاملا مرتبط', 'cmb2' ),
        'id'			=>	$prefix . 'attached_posts',
        'type'			=>	'custom_attached_posts',
        'multiple'		=>	true,
        'options'		=>	array(
			// 'show_thumbnails'	=>	true, // Show thumbnails on the left
			'filter_boxes'			=>	true, // Show a text box for filtering the results
			'query_args'			=>	array( 'posts_per_page' => 20 ), // override the get_posts args
        )
    ) );

}

add_action( 'cmb2_admin_init', 'attribute_metabox' );
function attribute_metabox() {
	$prefix = 'amb_';

	$cmb = new_cmb2_box( array(
		'id'			=>	$prefix . 'title',
		'title'			=>	esc_html__( 'ویژگی ها', 'cmb2' ),
		'object_types'	=>	array( 'post', ),
		'show_on_cb'	=>	'specific_category_metabox',
	) );

	$cmb->add_field( array(
		'name'			=>	esc_html__( 'افزودن فیلم به اسلایدر', 'cmb2' ),
		'id'			=>	$prefix . 'add_to_slider',
		'type'			=>	'checkbox',
		'show_on_cb'	=>	'specific_category_field_movies',
	) );
	$cmb->add_field( array(
		'name'			=>	esc_html__( 'تاریخ اکران', 'cmb2' ),
		'id'			=>	$prefix . 'release_date',
		'type'			=>	'text_date',
		'show_on_cb'	=>	'specific_category_field_movies',
		'date_format'	=>	'Y/m/d',
	) );
	$cmb->add_field( array(
		'name'			=> esc_html__( 'نسخه های فیلم', 'cmb2' ),
		'id'			=> $prefix . 'movies_release',
		'type'			=> 'multicheck',
		'options'		=> array(
			'HDCam'		=>	esc_html__( 'HDCam', 'cmb2' ),
			'HDTS'		=>	esc_html__( 'HDTS', 'cmb2' ),
			'DVDSCR'	=>	esc_html__( 'DVDSCR', 'cmb2' ),
			'DVDRip'	=>	esc_html__( 'DVDRip', 'cmb2' ),
			'HDRip'		=>	esc_html__( 'HDRip', 'cmb2' ),
			'WEB-DL'	=>	esc_html__( 'WEB-DL', 'cmb2' ),
			'BluRay'	=>	esc_html__( 'BluRay', 'cmb2' ),
		),
		'show_on_cb'	=>	'specific_category_field_movies',
		// 'inline'  => true, // Toggles display to inline
		// 'multiple' => true, // Store values in individual rows
	) );
	$cmb->add_field( array(
		'name'    => esc_html__( 'نسخه های سریال', 'cmb2' ),
		'id'      => $prefix . 'series_release',
		'type'    => 'multicheck',
		'options' => array(
			'HDTV' => esc_html__( 'HDTV', 'cmb2' ),
			'WEB-DL' => esc_html__( 'WEB-DL', 'cmb2' ),
			'WEBRip' => esc_html__( 'WEBRip', 'cmb2' ),
		),
		'show_on_cb'	=>	'specific_category_field_series',
	) );
	$cmb->add_field( array(
		'name'			=>	esc_html__( 'افزودن سریال به جدول', 'cmb2' ),
		'id'			=>	$prefix . 'add_to_table',
		'type'			=>	'checkbox',
		'show_on_cb'	=>	'specific_category_field_series',
	) );
	$cmb->add_field( array(
		'name'				=>	esc_html__( 'روز پخش', 'cmb2' ),
		'id'				=>	$prefix . 'show_day',
		'type'				=>	'radio_inline',
		'options'			=> array(
			'sat'			=>	esc_html__( 'شنبه', 'cmb2' ),
			'sun'			=>	esc_html__( 'یکشنبه', 'cmb2' ),
			'mon'			=>	esc_html__( 'دوشنبه', 'cmb2' ),
			'tue'			=>	esc_html__( 'سه شنبه', 'cmb2' ),
			'wed'			=>	esc_html__( 'چهار شنبه', 'cmb2' ),
			'thu'			=>	esc_html__( 'پنجشنبه', 'cmb2' ),
			'fri'			=>	esc_html__( 'جمعه', 'cmb2' ),
		),
		'show_on_cb'	=>	'specific_category_field_series',
	) );
	$cmb->add_field( array(
		'name'			=>	esc_html__( 'فصل های سریال', 'cmb2' ),
		'id'			=>	$prefix . 'seasons',
		'type'			=>	'text',
		'attributes'	=>	array(
			'type'		=>	'number',
			'step'		=>	'any',
		),
		'show_on_cb'	=>	'specific_category_field_series',
	) );
	$cmb->add_field( array(
		'name'			=>	esc_html__( 'قسمت های سریال', 'cmb2' ),
		'id'			=>	$prefix . 'episodes',
		'type'			=>	'text',
		'attributes'	=>	array(
			'type'		=>	'number',
			'step'		=>	'any',
		),
		'show_on_cb'	=>	'specific_category_field_series',
	) );

}

add_action( 'cmb2_admin_init', 'page_metabox' );
function page_metabox() {
	$prefix = 'pmb_';

	$cmb_about_page = new_cmb2_box( array(
		'id'		  => $prefix . 'title',
		'title'        => esc_html__( 'About Page Metabox', 'cmb2' ),
		'object_types' => array( 'page', ), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		'show_on'      => array( 'id' => array( 3114, ) ), // Specific post IDs to display this metabox
	) );

	$cmb_about_page->add_field( array(
		'name' => esc_html__( 'Test Text', 'cmb2' ),
		'desc' => esc_html__( 'field description (optional)', 'cmb2' ),
		'id'   => $prefix . 'text',
		'type' => 'text',
	) );

}