<?php
/*
Plugin Name: Weekly Table Widget
Author: M3HDI
Version: 1
*/

class WeeklyTable extends WP_Widget {
	// constructor
    function WeeklyTable() {
		parent::__construct( false, __( 'ابزارک جدول پخش هفتگی', 'WeeklyTable' ), 'description=' . __( 'نمایش روز پخش سریال ها', 'WeeklyTable' ) );
    }

	// widget form creation
	function form($instance) {

	if( $instance) {
		$title = esc_attr($instance['title']);
	} else {
		$title = '';
	}
	?>

	<p>
		<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان', 'WeeklyTable'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
	</p>

	<?php }

	// update widget
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['title'] = strip_tags($new_instance['title']);
		return $instance;
	}

	// Display widget
	function widget($args, $instance) {
		extract( $args );
		// these are the widget options
		$title = apply_filters('widget_title', $instance['title']);
		$postnumber = $instance['postnumber'];
		echo $before_widget;

		// Check if title is set
		if ( $title ) {
			echo $before_title . $title . $after_title;
		} ?>

		<!-- WIDGET CODE START -->
		<div class="wtable" id="wtable">

			<ul class="days-row">
				<li class="days active" data-week-day="0">شنبه</li>
				<li class="days" data-week-day="1">يکشنبه</li>
				<li class="days" data-week-day="2">دوشنبه</li>
				<li class="days" data-week-day="3">سه شنبه</li>
				<li class="days" data-week-day="4">چهارشنبه</li>
				<li class="days" data-week-day="5">پنجشنبه</li>
				<li class="days" data-week-day="6">جمعه</li>
			</ul>

			<ul class="titles-row">
				<li class="name">نام سريال</li>
				<li class="score">امتیاز</li>
				<li class="seasons">فصل</li>
				<li class="episodes">قسمت</li>
				<li class="image">عکس سريال</li>
			</ul>

			<div class="keeper">
				<div class="mover">

					<!--جدول پخش براي روز شنبه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell0">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'sat' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

					<!--جدول پخش براي روز يکشنبه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell1">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'sun' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

					<!--جدول پخش براي روز دوشنبه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell2">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'mon' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

					<!--جدول پخش براي روز سه شنبه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell3">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'tue' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

					<!--جدول پخش براي روز چهارشنبه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell4">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'wed' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

					<!--جدول پخش براي روز پنج شنبه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell5">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'thu' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

					<!--جدول پخش براي روز جمعه-->
					<?php $recentPosts = new WP_Query( array( 'posts_per_page' => -1,'cat' => 2,'order' => 'ASC','orderby' => 'title','meta_key'  => 'amb_add_to_table' ) ); ?>
						<ul class="cell" id="cell6">
							<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
								<?php $amb_show_day = get_post_meta( get_the_ID(), 'amb_show_day', true ); ?>
								<?php if ( $amb_show_day == 'fri' ) { ?>
									<?php
										$dmb_english_name = get_post_meta( get_the_ID(), 'dmb_english_name', true );
										$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
										$amb_seasons = get_post_meta( get_the_ID(), 'amb_seasons', true );
										$amb_episodes = get_post_meta( get_the_ID(), 'amb_episodes', true );
										$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
									?>
									<li>
										<a class="name" href="<?php the_permalink();?>" target="_blank"><?php echo $dmb_english_name; ?></a>
										<span class="score"><?php echo $dmb_imdb_score; ?></span>
										<span class="seasons"><?php echo $amb_seasons; ?></span>
										<span class="episodes"><?php echo $amb_episodes; ?></span>
										<a href="<?php the_permalink();?>" target="_blank"><img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php echo $dmb_english_name; ?>" alt="<?php echo $dmb_english_name; ?>" width="227" height="42"></a>
									</li>
								<?php } ?>
							<?php endwhile; ?>
						</ul>
					<?php wp_reset_postdata(); ?>

				</div>
			</div>

		</div>
		<!-- WIDGET CODE END -->

		<?php echo $after_widget;
	}
}

// register widget
add_action('widgets_init', create_function('', 'return register_widget("WeeklyTable");')); ?>