/**
 * Alpus APRS Frontend JS
 * 
 * @since 1.0.0
 */
( function($) {
    var loadSummary = function () {
        var $wrapper = $('.alpus-aprs-wrapper'),
            $content = $wrapper.find('.alpus-aprs-content'),
            $error   = $wrapper.find('.alpus-aprs-error-msg'),
            post_id  = $wrapper.data('post-id');

        $wrapper.removeClass('hide');

        $.ajax({
            type: 'post',
            data: {
                action: 'alpus_apr_get_summary',
                nonce: alpus_aprs_frontend_vars.nonce,
                post_id: post_id
            },
            url: alpus_aprs_frontend_vars.ajax_url,
            success: function ( res ) {
                $wrapper.find('.loading-overlay').remove();
                $wrapper.removeClass('loading');
                if ( res.success ) {

                    $content.html(res.data)
                        .css('display', 'block');
                } else {
                    if ( res.data ) {
                        $error.html(wp.i18n.__('Failure, Please try again after refresh page.', 'alpus-aprs') + '<br/>' + res.data);
                    } else {
                        $error.html(wp.i18n.__('Failure, Please try again after refresh page.', 'alpus-aprs'));
                    }
                    
                    $error.addClass('show');
                    $content.css('display', 'none');
                }
            }
        });
    }

    $(document).ready(function() {
        loadSummary();
    });
} ) (jQuery);
