<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">

<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php endif; ?>
<?php wp_head(); ?>

<meta name="google-site-verification" content="_mjubS22aEf7YZL3R3xsy-Mkk0w5R24Qgt06BuowK7w" />

<link rel="shortcut icon" href="<?php bloginfo('template_url');?>/images/favicon.ico">
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/style.css" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/icon.css" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/like.css" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url');?>/css/slick.css" />
<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/jquery-1.11.2.min.js"></script>
<script src="https://apis.google.com/js/platform.js" async defer></script>
</head>

<body <?php body_class(); ?>>

	<h1 style="position: absolute;top: -400px;">زیرنویس سریال,دانلود زیرنویس فیلم,زیرنویس,دانلود زیرنویس فارسی سریال,دانلود زیرنویس,زیرنویس فیلم,زیرنویس فارسی فیلم,زیرنویس فارسی,دانلود زیرنویس سریال,دانلود زیرنویس فارسی,زیرنویس فارسی سریال,دانلود زیرنویس فارسی فیلم و سریال,دانلود زیرنویس فیلم و سریال,مرجع دانلود زیرنویس فارسی</h1>

	<div class="container">

		<header>
			<div class="logo">
				<a title="پارسی ساب" href="/">
					<img width="160" height="80" alt="پارسی ساب" title="پارسی ساب" src="<?php bloginfo('template_url') ;?>/images/logo.png">
				</a>
			</div>

			<ul class="toplink">
				<li><a href="/contact-us">ارتباط با ما</a></li>
				<li><a href="/ads/">تبلیغات</a></li>
				<li><a href="/">خانه</a></li>
				<li class="icon-list PushMenu menu-right push-body"></li>
			</ul>

			<div class="search widget">
				<form action="<?php echo get_site_url(); ?>" name="searchform" method="get">
					<input type="text" placeholder="جستجو..." value="" name="s" />
					<button type="submit">
						<i class="icon icon-search"></i>
					</button>
				</form>
			</div>

			<div class="cbp-spmenu cbp-spmenu-vertical cbp-spmenu-right">
				<div class="logo">
					<a href="/" title="پارسی ساب">
						<img src="<?php bloginfo('template_url') ;?>/images/logo.png" alt="پارسی ساب">
					</a>
				</div>
				<div class="categories widget">
					<div class="widget-body">
						<ul>
							<?php wp_list_categories( array(
								'show_count'	=>	1,
								'orderby'	=>	'name',
								'style' 	=> 	'list',
								'title_li'	=>	false
							) ); ?> 
						</ul>
					</div>
				</div>
			</div>
			<script>
			jQuery(document).ready(function($) {
				$('.PushMenu').jPushMenu();
			});
			</script>
		</header>

		<nav>
			<ul>
				<li><a href="/category/series-subtitle/" title="زیرنویس سریال ها"><i class="icon-tv"></i>زیرنویس سریال ها</a></li>
				<li><a href="/category/movies-subtitle/" title="زیرنویس فیلم ها"><i class="icon-film"></i>زیرنویس فیلم ها</a></li>
				<li><a href="/category/top-series/" title="بهترین سریال ها"><i class="icon-video-camera"></i>بهترین سریال ها</a></li>
				<li><a href="/category/top-movies/" title="بهترین فیلم ها"><i class="icon-film4"></i>بهترین فیلم ها</a></li>
				<li><a href="/category/review/" title="نقد و بررسی"><i class="icon-document-edit2"></i>نقد و بررسی</a></li>
				<li><a href="/category/education/" title="آموزش ها و مشکلات"><i class="icon-help2"></i>آموزش ها و مشکلات</a></li>
			</ul>
		</nav>

		<div class="header-ads">
		</div>