﻿<?php

if ( post_password_required() )
	return;
?>

<div id="comments" class="comments-area">
	<?php
		$commenter     = wp_get_current_commenter();
		$user          = wp_get_current_user();
		$user_identity = $user->exists() ? $user->display_name : '';
		$req           = get_option( 'require_name_email' );
		$aria_req      = ( $req ? " aria-required='true'" : '' );
	?>

	<ol>
		<p style="text-align:center;"> لطفا قبل از ارسال دیدگاه خود، موارد زیر را به دقت مطالعه کنید :</p>
		<p style="text-align:center;">=-=-=-=-=-=-==-=-=</p>
		<li>دیدگاهی که به غیر از زبان فارسی یا غیر مرتبط با مطلب باشد منتشر نخواهد شد.</li>
		<li>دیدگاه ارسال شده توسط شما ، پس از تایید توسط مدیران سایت منتشر خواهد شد.</li>
	</ol>

	<?php

		$fields = array(
			'author' => '<input class="author_name" name="author" type="text" placeholder="نام شما (الزامی)" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' />',
			'email' => '<input class="author_email" name="email" type="text" placeholder="ایمیل شما (الزامی)" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' />',
			'textarea' => '<textarea id="comment" name="comment" placeholder="متن خود را بنویسید ..." aria-required="true"></textarea>',
			'add' => '<button class="blackey" type="reset">پاک کردن</button>',
			'url' => '',  //removes website field
		);

		$comment_form = array(
			'fields' => apply_filters( 'comment_form_default_fields', $fields ),
			'must_log_in' => '<p class="must-log-in">' .  sprintf('شما باید <a href="%s">وارد شوید</a> تا نظر بنویسید.' , wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</p>',
			'logged_in_as' => '',
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'title_reply' =>  '',
			'title_reply_to' =>  'پاسخ به %s',
			'cancel_reply_link' => 'انصراف',
			'label_submit' => 'ارسال',
			'comment_field' => '',
		);

		comment_form( apply_filters( 'comment_form_default_fields', $comment_form ) );

	?>

	<?php if ( have_comments() ) : ?>
	<ul class="comment-list">
		<?php
			wp_list_comments( array(
				'callback'			=>	'custom_comments',
				'reverse_top_level'	=>	true,
				'style'				=>	'ul'
			) );
		?>
	</ul>
	<?php endif; ?>

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
	<div class="navigation">
		<div class="previous_comments"><?php previous_comments_link('نظرات قدیمی') ?></div>
		<div class="next_comments"><?php next_comments_link('نظرات جدید'); ?></div>
	</div>
	<?php endif; ?>

	<?php if ( ! comments_open() && get_comments_number() ) : ?>
	<p class="no-comments">نظرات بسته شده است.</p>
	<?php endif; ?>

</div>