<?php

//Other Functions
add_theme_support( 'post-thumbnails' );
add_filter( 'pre_option_link_manager_enabled', '__return_true' );
$wpdb->query( "DELETE FROM $wpdb->posts WHERE post_type = 'revision' " );

//Meta Boxes
include (TEMPLATEPATH . '/includes/template/cmb2.php');

function register_my_menus() {
register_nav_menus(
	array(
		'navmenu' => __( 'منوی بالا' )
		)
	);
}
add_action( 'init', 'register_my_menus' );

//Sidebars
register_sidebar (
	array(
	'name'			=>	'سایدبار راست',
	'before_widget'	=>	'<div class="widget">',
	'after_widget'	=>	'</div></div>',
	'before_title'	=>	'<h3>',
	'after_title'	=>	'</h3><div class="widget-body">',
	)
);

register_sidebar (
	array(
	'name'			=>	'سایدبار چپ',
	'before_widget'	=>	'<div class="widget %2$s">',
	'after_widget'	=>	'</div></div>',
	'before_title'	=>	'<h3>',
	'after_title'	=>	'</h3><div class="widget-body">',
	)
);

register_sidebar (
	array(
	'name'			=>	'سایدبار میانی',
	'before_widget'	=>	'<div class="widget %2$s">',
	'after_widget'	=>	'</div>',
	'before_title'	=>	'<h3>',
	'after_title'	=>	'</h3>',
	)
);

register_sidebar (
	array(
	'name'			=>	'سایدبار چپ مطالب',
	'before_widget'	=>	'<div class="widget">',
	'after_widget'	=>	'</div></div>',
	'before_title'	=>	'<h3>',
	'after_title'	=>	'</h3><div class="widget-body">',
	)
);

register_sidebar(
	array(
	'name'			=>	'سایدبار فوتر',
	'before_widget'	=>	'<div class="widget">',
	'after_widget'	=>	'</div></div>',
	'before_title'	=>	'<h3>',
	'after_title'	=>	'</h3><div class="fw widget-body">',
	)
);

//Exclusive Widgets
include (TEMPLATEPATH . '/includes/widget/search.php');
include (TEMPLATEPATH . '/includes/widget/slider.php');
include (TEMPLATEPATH . '/includes/widget/time_line.php');
include (TEMPLATEPATH . '/includes/widget/tab_content.php');
include (TEMPLATEPATH . '/includes/widget/weekly_table.php');
include (TEMPLATEPATH . '/includes/widget/recent_posts.php');

//Admin Panel CSS
function my_admin_theme_style() {
	wp_enqueue_style('my-admin-theme', get_template_directory_uri().'/css/admin-panel.css');
}
add_action('admin_enqueue_scripts', 'my_admin_theme_style');

//Convert English Number to Farsi 
function ztjalali_convertToFarsi($matches) {
	global $ztjalali_option;
	if ($ztjalali_option['change_point_to_persian'])
		$farsi_array = array("۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹", "٫");
	else
		$farsi_array = array("۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹", ".");
		$english_array = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".");
		$out = '';
	if (isset($matches[1])) {
		return str_replace($english_array, $farsi_array, $matches[1]);
	}
	return $matches[0];
}
function ztjalali_persian_num($content) {
	//return preg_replace_callback('/(?:&#\d{2,4};)|((?:\&nbsp\;)*\d+(?:\&nbsp\;)*\d*\.*(?:\&nbsp\;)*\d*(?:\&nbsp\;)*\d*)|(?:[a-z](?:[\x00-\x3B\x3D-\x7F]|<\s*[^>]+>)*)|<\s*[^>]+>/i', 'ztjalali_convertToFarsi', $content);
	return preg_replace_callback('/(?:&#\d{2,4};)|(\d+[\.\d]*)|(?:[a-z](?:[\x20-\x3B\x3D-\x7F]|<\s*[^>]+>)*)|<\s*[^>]+>/i', 'ztjalali_convertToFarsi', $content);
}

//Convert Farsi Number to English
//Use it : echo en2fa($variable);
function en2fa($matn){
	$matn = str_replace('۰' , '0' , $matn);
	$matn = str_replace('۱' , '1' , $matn);
	$matn = str_replace('۲' , '2' , $matn);
	$matn = str_replace('۳' , '3' , $matn);
	$matn = str_replace('۴' , '4' , $matn);
	$matn = str_replace('۵' , '5' , $matn);
	$matn = str_replace('۶' , '6' , $matn);
	$matn = str_replace('٧' , '7' , $matn);
	$matn = str_replace('۸' , '8' , $matn);
	$matn = str_replace('۹' , '9' , $matn);
	return $matn;
}

//Excerpt Word Length Limit
function excerpt($limit) {
	$excerpt = explode(' ', get_the_excerpt(), $limit);
	if (count($excerpt)>=$limit) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt).' ...';
	} else {
		$excerpt = implode(" ",$excerpt);
	}
	$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
	return '<p>' . $excerpt . '</p>';
}

// Change Style Of Dispaly Count Of Post In Categories
add_filter('wp_list_categories', 'cat_count_span');
function cat_count_span($links) {
	$links = str_replace('</a> (', '</a> <span>', $links);
	$links = str_replace(')', '</span>', $links);
	return $links;
}

//Execute PHP In Widget
function execute_php($html){
	 if(strpos($html,"<"."?php")!==false){
		  ob_start();
		  eval("?".">".$html);
		  $html=ob_get_contents();
		  ob_end_clean();
	 }
	 return $html;
}
add_filter('widget_text','execute_php',100);

//Thumbs Rating
function thumbs_rating_print($content) {
	return $content.thumbs_rating_getlink();
}

//Popular Posts
function popularPosts($num) {
	global $wpdb;   
	$posts = $wpdb->get_results("SELECT comment_count, ID, post_title FROM $wpdb->posts ORDER BY comment_count DESC LIMIT 0 , $num");  
	foreach ($posts as $post) {
		setup_postdata($post);
		$id = $post->ID;
		$title = $post->post_title;
		$count = $post->comment_count;
		if ($count != 0) {
			$popular .= '<li>';
			$popular .= '<a href="' . get_permalink($id) . '" title="' . $title . '">' . $title . '</a> ';
			$popular .= '</li>';
		}
	}
	return $popular;
}

//Excluded Category
function the_excluded_category($excludedcats = array()){
	$count = 0;
	$categories = get_the_category();
	foreach($categories as $category) {
		$count++;
		if ( !in_array($category->cat_ID, $excludedcats) ) {
			echo '<a href="' . get_category_link( $category->term_id ) . '" title="' . sprintf( __( "%s" ), $category->name ) . '" ' . '>' . $category->name.'</a>';

			if( $count != count($categories) ){
				echo ", ";
			}

		}
	}
}

//Comments
if ( is_user_logged_in() && current_user_can('contributor') ) {
		function approid_comment_form_fields( $comment_form ) {
			$comment_form['comment_field'] = '<textarea id="comment" name="comment" placeholder="متن خود را بنویسید ..."  aria-required="true" required></textarea>';
			return $comment_form;
		}
		add_filter('comment_form_default_fields','approid_comment_form_fields');
}

if ( is_user_logged_in() && !current_user_can('contributor') ) {
	function comment_extra_fields() { ?>
		<textarea id="comment" name="comment" placeholder="متن خود را بنویسید ..." aria-required="true" required></textarea>
		<button class="blackey" type="reset">پاک کردن</button>
	<?php }
	add_action('comment_form_logged_in_after','comment_extra_fields');
	add_action('comment_form_after_fields','comment_extra_fields');
}


function approid_enqueue_comment_reply() {
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 
		wp_enqueue_script( 'comment-reply' ); 
	}
}
add_action( 'wp_enqueue_scripts', 'approid_enqueue_comment_reply' );


function custom_comments($comment, $args, $depth) {
$GLOBALS['comment'] = $comment; ?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<div <?php comment_class(); ?> class="comment">
			<div class="cm_meta">
				<span class="author"><?php comment_author(); ?></span>
				<time class="date" <?php comment_time( 'c' ); ?> >
					<?php comment_date('j F Y'); ?>
				</time>
				<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 
					'reply_text' => 'پاسخ',
					'depth' => $depth,
					'max_depth' => $args['max_depth'] 
				) ) ); ?>
				</div>
			</div>
			<div class="cm_text">
				<?php if ( $comment->comment_approved == '0' ) : ?>
				<em>نظر شما بعد از تاييد مدير نمايش داده مي شود.</em>
				<?php endif; ?>
				<?php comment_text(); ?>
			</div>
		</div>
<?php }

?>