<?php
/*
Plugin Name: Search Widget
Author: M3HDI
Version: 1
*/

class SearchWidget extends WP_Widget {
	// constructor
    function SearchWidget() {
		parent::__construct( false, __( 'ابزارک جستجو', 'SearchWidget' ), 'description=' . __( 'ابزارک جستجوی اختصاصی سایت', 'SearchWidget' ) );
    }

	// widget form creation
	function form($instance) {

	if( $instance) {
		$title = esc_attr($instance['title']);
	} else {
		$title = '';
	}
	?>

	<p>
		<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان', 'SearchWidget'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
	</p>

	<?php }

	// update widget
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['title'] = strip_tags($new_instance['title']);
		return $instance;
	}

	// Display widget
	function widget($args, $instance) {
		extract( $args );
		// these are the widget options
		$title = apply_filters('widget_title', $instance['title']);
		$postnumber = $instance['postnumber'];
		echo $before_widget;

		// Check if title is set
		if ( $title ) {
			echo $before_title . $title . $after_title;
		} ?>

		<!-- WIDGET CODE START -->
		<p>برای جستجوی بهتر از کلمات کوتاه استفاده کنید</p>
		<form action="<?php echo get_site_url(); ?>" name="searchform" method="get">
			<input type="text" placeholder="جستجو..." value="" name="s" />
			<button type="submit">
				<i class="icon icon-search"></i>
			</button>
		</form>
		<!-- WIDGET CODE END -->

		<?php echo $after_widget;
	}
}

// register widget
add_action('widgets_init', create_function('', 'return register_widget("SearchWidget");')); ?>