<?php
/*
Plugin Name: Slider Widget
Author: M3HDI
Version: 1
*/

class SliderWidget extends WP_Widget {
	// constructor
    function SliderWidget() {
		parent::__construct( false, __( 'ابزارک اسلایدر', 'SliderWidget' ), 'description=' . __( 'ابزارک اسلایدر اختصاصی سایت', 'SliderWidget' ) );
    }

	// widget form creation
	function form($instance) {

	if( $instance) {
		$catid = esc_attr($instance['catid']);
		$slidenumber = esc_attr($instance['slidenumber']);
		$thumbnailnumber = esc_attr($instance['thumbnailnumber']);
	} else {
		$catid = '';
		$slidenumber = '';
		$thumbnailnumber = '';
	}
	?>

	<p>
		<label for="<?php echo $this->get_field_id('catid'); ?>"><?php _e('شماره دسته بندی:', 'SliderWidget'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('catid'); ?>" name="<?php echo $this->get_field_name('catid'); ?>" type="number" value="<?php echo $catid; ?>" step="any" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('slidenumber'); ?>"><?php _e('تعداد اسلایدها:', 'SliderWidget'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('slidenumber'); ?>" name="<?php echo $this->get_field_name('slidenumber'); ?>" type="number" value="<?php echo $slidenumber; ?>" step="any" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('thumbnailnumber'); ?>"><?php _e('تعداد تصاویر بند انگشتی:', 'SliderWidget'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('thumbnailnumber'); ?>" name="<?php echo $this->get_field_name('thumbnailnumber'); ?>" type="number" value="<?php echo $thumbnailnumber; ?>" step="any" />
	</p>

	<?php }

	// update widget
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['catid'] = strip_tags($new_instance['catid']);
		$instance['slidenumber'] = strip_tags($new_instance['slidenumber']);
		$instance['thumbnailnumber'] = strip_tags($new_instance['thumbnailnumber']);
		return $instance;
	}

	// Display widget
	function widget($args, $instance) {
		extract( $args );
		// these are the widget options
		$catid = $instance['catid'];
		$slidenumber = $instance['slidenumber'];
		$thumbnailnumber = $instance['thumbnailnumber'];
		echo $before_widget;

		// Check if Category ID is set
		if( $catid ) { ?>

			<!-- WIDGET CODE START -->
			<?php $recentPosts = new WP_Query( array( 'cat' => $catid,'order' => 'DESC','orderby' => 'date','meta_key'  => 'amb_add_to_slider' ) ); ?>
				<ul class="slider">
					<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
						<?php
							$amb_add_to_slider = get_post_meta( get_the_ID(), 'amb_add_to_slider', true );
							$dmb_other_images = get_post_meta( get_the_ID(), 'dmb_other_images', true );
						?>
						<?php if ( $amb_add_to_slider == true ) { ?>
							<li>
								<a href="<?php the_permalink();?>" title="<?php the_title(); ?>" target="_blank">
									<img class="image" src="<?php echo $dmb_other_images; ?>" title="<?php the_title(); ?>" alt="<?php the_title(); ?>">
								</a>
								<a class="title" href="<?php the_permalink();?>" target="_blank">
									<?php if (strlen($post->post_title) > 90) { echo mb_substr(the_title($before = '', $after = '', FALSE), 0, 60) . '...'; } else { the_title(); } ?>
								</a>
							</li>
						<?php } ?>
					<?php endwhile; ?>
				</ul>
				<ul class="slider-nav">
					<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
						<li><?php if ( has_post_thumbnail()) the_post_thumbnail('thumbnail'); ?></li>
					<?php endwhile; ?>
				</ul>
			<?php wp_reset_postdata(); ?>
			<script type="text/javascript">
				$(document).ready(function(){
					$('.slider').slick({
						rtl: true,
						fade: true,
						arrows: true,
						infinite: true,
						autoplay: true,
						slidesToShow: <?php echo $slidenumber; ?>,
						slidesToScroll: 1,
						asNavFor: '.slider-nav'
					});
					$('.slider-nav').slick({
						vertical: true,
						focusOnSelect: true,
						slidesToShow: <?php echo $thumbnailnumber; ?>,
						slidesToScroll: 1,
						asNavFor: '.slider'
					});
				});
			</script>
			<!-- WIDGET CODE END -->

		<?php }

		echo $after_widget;
	}
}

// register widget
add_action('widgets_init', create_function('', 'return register_widget("SliderWidget");')); ?>