<?php
/*
Plugin Name: Display Post In Tab Widget
Author: M3HDI
Version: 1
*/

class TabContent extends WP_Widget {
	// constructor
    function TabContent() {
		parent::__construct( false, __( 'نمایش مطالب بر اساس', 'TabContent' ), 'description=' . __( 'نمایش تب بندی شده مطالب', 'TabContent' ) );
    }

	// widget form creation
	function form($instance) {

	if( $instance) {
		$title = esc_attr($instance['title']);
	} else {
		$title = '';
	}
	?>

	<p>
		<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان', 'TabContent'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
	</p>

	<?php }

	// update widget
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['title'] = strip_tags($new_instance['title']);
		return $instance;
	}

	// Display widget
	function widget($args, $instance) {
		extract( $args );
		// these are the widget options
		$title = apply_filters('widget_title', $instance['title']);
		$postnumber = $instance['postnumber'];
		echo $before_widget;

		// Check if title is set
		if ( $title ) {
			echo $before_title . $title . $after_title;
		} ?>

		<!-- WIDGET CODE START -->
		<section>
			<div class="tabs">
				<div>
					<ul>
						<li><a href="#recent">آخرین</a></li>
						<li><a href="#like">برترین</a></li>
						<li><a href="#comments">محبوب ترین</a></li>
					</ul>
				</div>
				<div class="content-wrap">
					<section id="recent">
						<?php $recentPosts = new WP_Query( array( 'posts_per_page' => 15 ) ); ?>
						<ul>
						<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
							<li><a href="<?php the_permalink();?>"><?php if (strlen($post->post_title) > 90) { echo mb_substr(the_title($before = '', $after = '', FALSE), 0, 60) . '...'; } else { the_title(); } ?></a></li>
						<?php endwhile; ?>
						</ul>
						<?php wp_reset_query(); ?>
					</section>
					<section id="like">
						<?php echo do_shortcode( '[thumbs_rating_top type="positive" posts_per_page="15" post_type="post" show_votes="no" order="DESC"]' ); ?>
					</section>
					<section id="comments">
						<ul>
							<?php echo popularPosts(15); ?>
						</ul>
					</section>
				</div>
			</div>
		</section>
		<script type="text/javascript" src="<?php bloginfo('template_url');?>/js/TabsInlineScript.js"></script>
		<!-- WIDGET CODE END -->

		<?php echo $after_widget;
	}
}

// register widget
add_action('widgets_init', create_function('', 'return register_widget("TabContent");')); ?>