<?php
/*
Plugin Name: Display Post In Time Line Widget
Author: M3HDI
Version: 1
*/

class TimeLine extends WP_Widget {
	// constructor
    function TimeLine() {
		parent::__construct( false, __( 'خط زمان', 'TimeLine' ), 'description=' . __( 'نمایش مطالب به صورت خط زمانی', 'TimeLine' ) );
    }

	// widget form creation
	function form($instance) {

	if( $instance) {
		$title = esc_attr($instance['title']);
		$postnumber = esc_attr($instance['postnumber']);
	} else {
		$title = '';
		$postnumber = '';
	}
	?>

	<p>
		<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('عنوان', 'TimeLine'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id('postnumber'); ?>"><?php _e('تعداد مطالب:', 'TimeLine'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('postnumber'); ?>" name="<?php echo $this->get_field_name('postnumber'); ?>" type="number" value="<?php echo $postnumber; ?>" step="any" />
	</p>

	<?php }

	// update widget
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['postnumber'] = strip_tags($new_instance['postnumber']);
		return $instance;
	}

	// Display widget
	function widget($args, $instance) {
		extract( $args );
		// these are the widget options
		$title = apply_filters('widget_title', $instance['title']);
		$postnumber = $instance['postnumber'];
		echo $before_widget;

		// Check if title is set
		if ( $title ) {
			echo $before_title . $title . $after_title;
		} ?>

			<?php $recentPosts = new WP_Query( array( 'posts_per_page' => $postnumber,'cat' => '46','meta_key'  => 'amb_release_date' ) );  ?>
			<ul>
				<?php while ($recentPosts->have_posts()) : $recentPosts->the_post(); ?>
				<li>
					<h2><a href="<?php the_permalink();?>" target="_blank" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php if (strlen($post->post_title) > 90) { echo mb_substr(the_title($before = '', $after = '', FALSE), 0, 60) . '...'; } else { the_title(); } ?></a></h2>

					<?php
						$acf_movies_release = get_post_meta( get_the_ID(), 'movies_release', true );
						$amb_movies_release = get_post_meta( get_the_ID(), 'amb_movies_release', true );
						$amb_release_date = get_post_meta( get_the_ID(), 'amb_release_date', true );
						$dmb_imdb_score = get_post_meta( get_the_ID(), 'dmb_imdb_score', true );
					?>
					<?php if ( !empty($amb_movies_release) ) { ?>
						<div class="one">
							<ul>
								<?php foreach ( $amb_movies_release as $release ) { ?>
									<li>
										<?php echo $release; ?>
									</li>
								<?php } ?>
							</ul>
						</div>
					<?php } elseif ( !empty($acf_movies_release) ) { ?>
						<div class="one">
							<ul>
								<?php foreach( $acf_movies_release as $release ): ?>
								<li>
									<?php echo $release; ?>
								</li>
								<?php endforeach; ?>
							</ul>
						</div>
					<?php } ?>

					<span class="two">
						<label>تاریخ اکران :</label>
						<strong><?php echo $amb_release_date; ?></strong>
					</span>

					<?php if ( !empty( $dmb_imdb_score ) ) : ?>
					<span class="three">
						<label>امتیاز :</label>
						<strong><?php echo $dmb_imdb_score; ?></strong>
					</span>
					<?php endif; ?>
				</li>
				<?php endwhile; ?>
			</ul>
			<?php wp_reset_query(); ?>

		<?php echo $after_widget;
	}
}

// register widget
add_action('widgets_init', create_function('', 'return register_widget("TimeLine");')); ?>